<?php
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/www/admin/lib-zones.inc.php';
require_once MAX_PATH . '/www/admin/lib-size.inc.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH . '/lib/max/Admin/Invocation/Publisher.php';


$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

/*-------------------------------------------------------*/
/* Affiliate interface security                          */
/*-------------------------------------------------------*/

OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER, OA_ACCOUNT_TRAFFICKER);
OA_Permission::enforceAccountPermission(OA_ACCOUNT_TRAFFICKER, OA_PERM_SUPER_ACCOUNT);
OA_Permission::enforceAccessToObject('affiliates', $affiliateid);



if (OA_Permission::isAccount(OA_ACCOUNT_TRAFFICKER)) {
    OA_Permission::enforceAllowed(OA_PERM_ZONE_INVOCATION);
}

/*-------------------------------------------------------*/
/* Store preferences									 */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['affiliateid'] = $affiliateid;
phpAds_SessionDataStore();

/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/
$oHeaderModel = MAX_displayWebsiteBreadcrumbs($affiliateid);
if (OA_Permission::isAccount(OA_ACCOUNT_MANAGER)) {
    // Get other affiliates
    $doAffiliates = OA_Dal::factoryDO('affiliates');
    $doAffiliates->addSessionListOrderBy('affiliate-link.php');
    $doAffiliates->agencyid = $agencyid;
    $doAffiliates->find();
    while ($doAffiliates->fetch() && $row = $doAffiliates->toArray()) {
        phpAds_PageContext(
            MAX_buildName ($row['affiliateid'], $row['name']),
            "affiliate-invocation.php?affiliateid=".$row['affiliateid'],
            $affiliateid == $row['affiliateid']
        );
    }
    addWebsitePageTools($affiliateid);
    phpAds_PageHeader("4.2.5", $oHeaderModel);
} else {
    $sections = array();
    $sections[] = "2.1";
    if (OA_Permission::hasPermission(OA_PERM_ZONE_INVOCATION)) {
        $sections[] = "2.2";
    }
    phpAds_PageHeader('2.2', $oHeaderModel);
    phpAds_ShowSections($sections);
}

/*-------------------------------------------------------*/
/* Main code                                             */
/*------------------------------------------------------

require_once MAX_PATH . '/lib/max/Admin/Invocation/Publisher.php';
$maxInvocation = new MAX_Admin_Invocation_Publisher();

$maxInvocation->placeInvocationForm();

/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/

//Insert
	 $checkpublisher_num = OA_Dal_Delivery_query("select a.*,b.account_id from ".$table_prefix."djax_dsp_publisher_assoc as a,rv_affiliates as b  where b.account_id = a.publisher_id and b.affiliateid='".$_GET['affiliateid']."'");
	
	 
if (isset($_POST['update']))
{
	
	$translation = new OX_Translation();
	$translated_message = $translation->translate ("<b style='color:red'>Updated Successfully.</b>");
	OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
	  
	
	$rowcheck = OA_Dal_Delivery_fetchAssoc($checkpublisher_num);
	$account_id = $rowcheck['account_id'];
	$dsp_id =$rowcheck['dsp_id'];
	$dsp_ids = explode(",",$dsp_id);
	$result=array_diff($dsp_ids,$_POST['dsps']);
	$deleterow = implode(',',$result);
	
	if(!in_array($dsp_id, $_POST['dsps']))
		  {
			  
			 $newList = str_replace($deleterow.",", "", $dsp_id);
			$result =  OA_Dal_Delivery_query("UPDATE ".$table_prefix."djax_dsp_publisher_assoc SET dsp_id = '".$newList."' WHERE dsp_id ='".$dsp_id."' AND publisher_id = ".$account_id);
			}
	
	
if (!empty($_POST['dsps']))
{
if(OA_Dal_Delivery_numRows($checkpublisher_num)>0)
{
	
	
	
	$checkpublisher_num = OA_Dal_Delivery_query("select a.*,b.account_id from ".$table_prefix."djax_dsp_publisher_assoc as a,".$table_prefix."affiliates as b  where b.account_id = a.publisher_id and b.affiliateid='".$_GET['affiliateid']."'");
	
	$rowcheck = OA_Dal_Delivery_fetchAssoc($checkpublisher_num);
	$account_id = $rowcheck['account_id'];
	

	
	/*if($_GET['page'] != '')
	{
		
		$selected1 = explode(",",$dsp_id);
		
		$sel1 = array_merge($selected1,$_POST['dsps']);
		$sel = implode(',',$sel1);
	
		
		OA_Dal_Delivery_query("UPDATE `".$table_prefix."djax_dsp_publisher_assoc` SET `dsp_id`='".$sel."' WHERE `publisher_id`=".$account_id."");
		
	
		}
		else
		{
			*/
	$selected =implode(",",$_POST['dsps']);
	
	OA_Dal_Delivery_query("UPDATE `".$table_prefix."djax_dsp_publisher_assoc` SET `dsp_id`='".$selected."' WHERE `publisher_id`=".$account_id."");
//}
}
else
{
	$checkpublisher_num = OA_Dal_Delivery_query("select account_id from ".$table_prefix."affiliates where affiliateid='".$_GET['affiliateid']."'");
	$rowcheck = OA_Dal_Delivery_fetchAssoc($checkpublisher_num);
	$account_id = $rowcheck['account_id'];
	$selected =implode(",",$_POST['dsps']);
	OA_Dal_Delivery_query("Insert into ".$table_prefix."djax_dsp_publisher_assoc(publisher_id,dsp_id) Values(".$account_id.",
	'".$selected."')");
	
}
}
else
{
	OA_Dal_Delivery_query("delete from {$table_prefix}djax_dsp_publisher_assoc where publisher_id = ".$account_id);
}

}
//Insert



    

$qry =OA_Dal_Delivery_query("select account_id from rv_affiliates where affiliateid ='".$_GET['affiliateid']."'");
$row = OA_Dal_Delivery_fetchAssoc($qry);

	
	$account_id = $row['account_id'];
	



$dsp_sql = OA_Dal_Delivery_query("SELECT id, adnetwork_name, publisher FROM rv_djax_video_adnetwork WHERE  status = 1 ORDER BY id DESC");

		if(OA_Dal_Delivery_numRows($dsp_sql) >0)
		{
		
		$target_sql = OA_Dal_Delivery_query("SELECT DISTINCT GROUP_CONCAT(adnet_id) as dsp FROM rv_djax_video_target_publisher where account_id = ".$account_id);
		$target = OA_Dal_Delivery_fetchAssoc($target_sql);
		$target_array =explode(',', $target['dsp']);
				while($dsp_temp = OA_Dal_Delivery_fetchAssoc($dsp_sql))
			{
				
				$dsp[] = $dsp_temp;
				//print_r($target_array);

				//print_r($target_array);
				$filter_dsp = array();
				
			}
			
				
				foreach($dsp as $key => $data){
			
					if($data['publisher'] == 1 && !in_array($data['id'], $target_array)){
						
						unset($dsp[$key]);
						
					}
					if($data['publisher'] == 2 && in_array($data['id'], $target_array)){
						
						unset($dsp[$key]);
					}
				}
			
			//echo $dsp["adnetwork_name"];	
				//print_r($dsp);
				//return array_values($dsp);
		}
		
	
		
	
		
		
if(!empty($dsp))
	{
	?>
<form name='affiliateform' id="dsp" method='post'>
	

<table  cellspacing="0" cellpadding="0" border="0" width="100%">

<tr>
<td colspan="3" height="10"> </td>
</tr>
<tr>
<td colspan="3" height="10"> </td>
</tr>

	 <tr>
		 <td><a href="javascript:void(0)" id="btnSelectAll"  class="checkall" style="padding-left:10px;font-size:14px;"> &#10004;&nbsp;<b>Select all</b></a> &nbsp;&nbsp;  
		 <a id="btnDeselectAll" href="javascript:void(0)" name="clearall"  style="padding-left:10px;font-size:14px;">&#10006;&nbsp;<b>Clear all</b></a></td>
		 <input type="hidden" name="btnDeselectAll" id="btnDeselectAll" value="0">
	 </tr>
	<tr>
<td colspan="3" height="10"> </td>
</tr>
	 
	                               
	  <tr>
		<td style="padding-left:10px;width:80%;padding-bottom:30px;">
			<ul>

<?php
				
					
foreach($dsp as $key => $row)
{	
	  $publisher= $row['publisher'];
	  $publicid = $row['id'];
	  $adnetworkname =$row['adnetwork_name'];
	  
	  

	  
?>
<li style="font-size:14px;">
<input type='checkbox' name="dsps[]" class="dsp_check" value="<?php echo $publicid;?>" <?php 

 $checkpublisher = OA_Dal_Delivery_query("select a.*,b.account_id from rv_djax_dsp_publisher_assoc as a,rv_affiliates as b where b.account_id = a.publisher_id and b.affiliateid='".$_GET['affiliateid']."' group by b.account_id");
 
	 if($checkrow = OA_Dal_Delivery_fetchAssoc($checkpublisher))
	 {
		 
		
	 $publisher_id = $checkrow['publisher_id'];
	 
	 $dsp_id       =explode(",",$checkrow['dsp_id']);
	 
	
	 if(in_array($publicid, $dsp_id))
		  {
			 echo $valueselect= "checked=checked";
			
		  }
		  else
		  {
			  echo $valueselect= "";
		  }
}



?>>

<?php echo $row['adnetwork_name'];

}

?>
</li>
</ul>

</td>
</tr>

<tr>
<td style="padding-left:20px;"><input type="submit"  name="update" value="Update" style="font-family: Arial,Helvetica,sans-serif;
    font-size: 15px;font-weight:bold;"></td>
</tr>
</table>
</form>



<br/>
<br/>
<?php
}


else
{
	
?>

<form>
	<table>
		<tr>
			<td>
				 CURRENTLY THERE ARE NO ADNETWORK AVAILABLE TO LIST
			</td>
		</tr>
	</table>
</form>

<?php
}

 ?>
<script type='text/javascript' src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.0/jquery.min.js"></script>
<script>
	var jq = jQuery.noConflict(true);
</script>
<script type="text/javascript">
	
	jq(document).ready(function(){

	function checkboxValues() { 
		
	    var allVals = [];
	    jq('.dsp_check:checked').each(function() {
	       allVals.push(jq(this).val());
	    });
	    return allVals; // process the array as you wish in the function so it returns what you need serverside
	}
	jq(function(){
		
		
		
		jq("#btnSelectAll").click(function () {
			
			
			
    	 	jq('.dsp_check').prop("checked", true);
    	 	//if(jq('.dsp_check').is(':checked')) { alert("it's checked"); }
    	
 		});

 		jq("#btnDeselectAll").click(function () {
    	 	jq('.dsp_check').removeAttr('checked');
    	 	
    	 	jq.ajax({
            url: "delete.php?affiliateid=<?Php //echo $_GET['affiliateid']?>",
            success: function(data){
               //alert(data)
             }
          });
 		});

	});
	
	});
</script>

<?
phpAds_PageFooter();
?>

